(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     16609,        486]
NotebookOptionsPosition[     14401,        432]
NotebookOutlinePosition[     14775,        448]
CellTagsIndexPosition[     14732,        445]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"s", ",", "chart1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "16"}], 
     SuperscriptBox["t", "2"]}], "+", 
    RowBox[{"96", "t"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Show", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"s", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "4"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"s", "[", "p", "]"}], "-", 
           RowBox[{"s", "[", "1", "]"}]}], 
          RowBox[{"p", "-", "1"}]], 
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}]}], "+", 
        RowBox[{"s", "[", "1", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"PointSize", "[", "Large", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"s", "[", "1", "]"}]}], "}"}], "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"p", ",", 
           RowBox[{"s", "[", "p", "]"}]}], "}"}], "]"}]}], "}"}], "]"}]}], 
    "\[IndentingNewLine]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", "3"}], "}"}], ",", "1.00001", ",", "3"}], "}"}]}], 
  "]"}]}], "Input",
 CellOpen->False,
 CellChangeTimes->{{3.7147907045432835`*^9, 3.714790748034055*^9}, {
  3.714791348775833*^9, 3.7147914032252674`*^9}, {3.714791600046418*^9, 
  3.7147918685746527`*^9}, {3.7147919080096817`*^9, 3.7147920136949725`*^9}, {
  3.7147925254766445`*^9, 3.714792526175723*^9}, {3.714792896026363*^9, 
  3.7147929699613743`*^9}},ExpressionUUID->"764d74a1-21ad-4265-bfdb-\
cbb59f5e7459"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`p$$ = 3., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`p$$], 3}, 1.00001, 3}}, Typeset`size$$ = {
    962., {291., 299.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`p$25954$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`p$$ = 3}, 
      "ControllerVariables" :> {
        Hold[$CellContext`p$$, $CellContext`p$25954$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        Plot[
         $CellContext`s[$CellContext`t], {$CellContext`t, 0, 4}], 
        Plot[(($CellContext`s[$CellContext`p$$] - $CellContext`s[
            1])/($CellContext`p$$ - 1)) ($CellContext`x - 1) + $CellContext`s[
          1], {$CellContext`x, 0, 4}, PlotStyle -> Red], 
        Graphics[{Green, 
          PointSize[Large], 
          Point[{1, 
            $CellContext`s[1]}], 
          Point[{$CellContext`p$$, 
            $CellContext`s[$CellContext`p$$]}]}]], 
      "Specifications" :> {{{$CellContext`p$$, 3}, 1.00001, 3}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{1034., {354., 363.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.714791744343483*^9, 3.7147917760672865`*^9, {3.7147918137122297`*^9, 
   3.714791871187764*^9}, {3.714792006953312*^9, 3.7147920146215134`*^9}, 
   3.714792816779024*^9, 3.7147928874838305`*^9, {3.714792945592669*^9, 
   3.714792970964212*^9}},ExpressionUUID->"16034852-3385-4804-b674-\
ceb8f0f26678"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t", ",", 
      FractionBox[
       RowBox[{
        RowBox[{"s", "[", "t", "]"}], "-", 
        RowBox[{"s", "[", "1", "]"}]}], 
       RowBox[{"t", "-", "1"}]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"{", 
       RowBox[{
       "3", ",", "2", ",", "1.5", ",", "1.1", ",", "1.01", ",", "1.001", ",", 
        "1.0001"}], "}"}]}], "}"}]}], "]"}], "//", "Grid"}]], "Input",
 CellChangeTimes->{{3.71479306665881*^9, 
  3.714793068216485*^9}},ExpressionUUID->"2a9f9819-0b82-4fec-98bb-\
364d3e2d8b73"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"chart1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       FractionBox[
        RowBox[{
         RowBox[{"s", "[", "t", "]"}], "-", 
         RowBox[{"s", "[", "1", "]"}]}], 
        RowBox[{"t", "-", "1"}]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"{", 
        RowBox[{
        "3", ",", "2", ",", "1.5", ",", "1.1", ",", "1.01", ",", "1.001", ",",
          "1.0001"}], "}"}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TableForm", "[", 
   RowBox[{"chart1", ",", 
    RowBox[{"TableHeadings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<t\>\"", ",", "\"\<Average Velocity from 1 to t\>\""}], 
        "}"}]}], "}"}]}]}], "]"}], "//", "Text"}]}], "Input",
 CellChangeTimes->{{3.714792542667261*^9, 3.7147926316294346`*^9}, {
  3.714792899738968*^9, 3.714792901742808*^9}, {3.7147929563866377`*^9, 
  3.714792958306444*^9}, {3.714793088514122*^9, 
  3.7147931019463816`*^9}},ExpressionUUID->"6e34073c-f6d4-4c80-aca1-\
1b0113ce0583"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"s", "[", "t", "]"}], "-", 
     RowBox[{"s", "[", "1", "]"}]}], 
    RowBox[{"t", "-", "1"}]], ",", 
   RowBox[{"t", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7147929870060687`*^9, 
  3.714793001516843*^9}},ExpressionUUID->"28d51287-34a9-42cd-bc07-\
5404788b255d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"f", ",", "chart"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "=", 
   FractionBox[
    RowBox[{
     SqrtBox["x"], "-", "1"}], 
    RowBox[{"x", "-", "1"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"chart", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"f", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.9", ",", "0.99", ",", "0.999", ",", "0.9999", ",", "1.0001", ",", 
         "1.001", ",", "1.01", ",", "1.1"}], "}"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TableForm", "[", 
   RowBox[{"chart", ",", 
    RowBox[{"TableHeadings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<x\>\"", ",", "\"\<f(x)\>\""}], "}"}]}], "}"}]}]}], "]"}],
   "//", "Text"}]}], "Input",
 CellChangeTimes->{{3.7147896913310432`*^9, 3.714789693993775*^9}, {
  3.714789736170667*^9, 3.714789828046177*^9}, {3.7147899817773952`*^9, 
  3.7147900149246206`*^9}, {3.7147913507770047`*^9, 3.714791355424417*^9}, {
  3.714792520366381*^9, 
  3.714792521228315*^9}},ExpressionUUID->"c5440515-4bcc-4eb1-bd76-\
123327216cdb"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"x", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7147930161258616`*^9, 
  3.7147930254110317`*^9}},ExpressionUUID->"baf0ebfc-5ca3-4e26-b47c-\
9e2e1d7b7e91"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", "x_", "]"}], "=", 
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "3"], "-", "8"}], 
    RowBox[{"4", 
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}]}]]}], ";"}]], "Input",
 CellChangeTimes->{{3.7147935843732176`*^9, 
  3.71479359256555*^9}},ExpressionUUID->"e1693fb2-a1ba-4332-81ab-\
2ba38e69c23e"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"h", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "8"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.714793564813148*^9, 3.714793630518567*^9}, 
   3.7147939645056987`*^9},ExpressionUUID->"09acd515-c5fe-48bf-a846-\
24077296950b"],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"h", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1.95"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "8"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"h", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2.05", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], ",", ".05"}], "]"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.714793699966126*^9, 3.714793775190687*^9}, {
  3.714793822697236*^9, 
  3.7147938752893887`*^9}},ExpressionUUID->"f2d20820-cdae-45a5-b33c-\
e41ca182c603"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"charth", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"h", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.9", ",", "1.99", ",", "1.999", ",", "1.9999", ",", "2.0001", ",", 
         "2.001", ",", "2.01", ",", "2.1"}], "}"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TableForm", "[", 
   RowBox[{"charth", ",", 
    RowBox[{"TableHeadings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<x\>\"", ",", "\"\<h(x)\>\""}], "}"}]}], "}"}]}]}], "]"}],
   "//", "Text"}]}], "Input",
 CellChangeTimes->{{3.7147942469872365`*^9, 
  3.71479428285452*^9}},ExpressionUUID->"89ec710b-7675-4ee0-83c2-\
b62cfbcaaf1e"],

Cell["Limit from the right:", "Text",
 CellChangeTimes->{{3.7147940381604013`*^9, 
  3.7147940581145067`*^9}},ExpressionUUID->"dc9ea3b4-ca0f-4ab6-ac83-\
1ded69246cd6"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"h", "[", "x", "]"}], ",", 
   RowBox[{"x", "\[Rule]", "2"}], ",", 
   RowBox[{"Direction", "\[Rule]", 
    RowBox[{"-", "1"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7147939937314606`*^9, 
  3.7147940140652885`*^9}},ExpressionUUID->"f9c27bd4-3a47-4651-a273-\
258a940cfc75"],

Cell["Limit from the left:", "Text",
 CellChangeTimes->{{3.714794061886651*^9, 
  3.7147940677141542`*^9}},ExpressionUUID->"690996eb-b9b5-4ceb-a40a-\
adea0d7c90e9"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"h", "[", "x", "]"}], ",", 
   RowBox[{"x", "\[Rule]", "2"}], ",", 
   RowBox[{"Direction", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7147940208098445`*^9, 
  3.714794033544671*^9}},ExpressionUUID->"5be6f13b-ec20-4881-ab7a-\
0b30a5e9e2d9"],

Cell["Two sided limit:", "Text",
 CellChangeTimes->{{3.714794072266799*^9, 
  3.714794075825223*^9}},ExpressionUUID->"fd5191b3-69ee-4d78-9e5c-\
dcb885943877"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"h", "[", "x", "]"}], ",", 
   RowBox[{"x", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7147938442128954`*^9, 
  3.7147938555844717`*^9}},ExpressionUUID->"0749cae5-1c81-4e3f-8d65-\
3a26893ff34c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"coschart", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Cos", "[", 
        FractionBox["1", "x"], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"{", 
        RowBox[{".001", ",", ".0001", ",", ".00001"}], "}"}]}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TableForm", "[", 
   RowBox[{"coschart", ",", 
    RowBox[{"TableHeadings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<x\>\"", ",", "\"\<cos \!\(\*FractionBox[\(1\), \(x\)]\)\>\""}], 
        "}"}]}], "}"}]}]}], "]"}], "//", "Text"}]}], "Input",
 CellChangeTimes->{{3.7147944825976214`*^9, 
  3.7147945751126566`*^9}},ExpressionUUID->"a9c57822-c133-4aba-b712-\
ef2037bad660"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    FractionBox["1", "x"], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     FractionBox["1", 
      RowBox[{"2", "\[Pi]"}]]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7147944360691977`*^9, 
  3.714794462732346*^9}},ExpressionUUID->"1688100b-bc66-426e-8c5f-\
b7b0a6aa1b04"]
},
WindowSize->{1280, 941},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
Magnification:>1.5 Inherited,
FrontEndVersion->"11.1 for Microsoft Windows (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 2212, 62, 28, "Input", "ExpressionUUID" -> \
"764d74a1-21ad-4265-bfdb-cbb59f5e7459",
 CellOpen->False],
Cell[2795, 86, 2321, 48, 742, "Output", "ExpressionUUID" -> \
"16034852-3385-4804-b674-ceb8f0f26678"]
}, Open  ]],
Cell[5131, 137, 623, 19, 66, "Input", "ExpressionUUID" -> \
"2a9f9819-0b82-4fec-98bb-364d3e2d8b73"],
Cell[5757, 158, 1137, 31, 98, "Input", "ExpressionUUID" -> \
"6e34073c-f6d4-4c80-aca1-1b0113ce0583"],
Cell[6897, 191, 373, 11, 66, "Input", "ExpressionUUID" -> \
"28d51287-34a9-42cd-bc07-5404788b255d"],
Cell[7273, 204, 1350, 39, 165, "Input", "ExpressionUUID" -> \
"c5440515-4bcc-4eb1-bd76-123327216cdb"],
Cell[8626, 245, 270, 7, 46, "Input", "ExpressionUUID" -> \
"baf0ebfc-5ca3-4e26-b47c-9e2e1d7b7e91"],
Cell[8899, 254, 371, 12, 74, "Input", "ExpressionUUID" -> \
"e1693fb2-a1ba-4332-81ab-2ba38e69c23e"],
Cell[9273, 268, 578, 16, 46, "Input", "ExpressionUUID" -> \
"09acd515-c5fe-48bf-a846-24077296950b"],
Cell[9854, 286, 1007, 30, 76, "Input", "ExpressionUUID" -> \
"f2d20820-cdae-45a5-b33c-e41ca182c603"],
Cell[10864, 318, 862, 26, 76, "Input", "ExpressionUUID" -> \
"89ec710b-7675-4ee0-83c2-b62cfbcaaf1e"],
Cell[11729, 346, 167, 3, 46, "Text", "ExpressionUUID" -> \
"dc9ea3b4-ca0f-4ab6-ac83-1ded69246cd6"],
Cell[11899, 351, 338, 9, 46, "Input", "ExpressionUUID" -> \
"f9c27bd4-3a47-4651-a273-258a940cfc75"],
Cell[12240, 362, 164, 3, 46, "Text", "ExpressionUUID" -> \
"690996eb-b9b5-4ceb-a40a-adea0d7c90e9"],
Cell[12407, 367, 316, 8, 46, "Input", "ExpressionUUID" -> \
"5be6f13b-ec20-4881-ab7a-0b30a5e9e2d9"],
Cell[12726, 377, 158, 3, 46, "Text", "ExpressionUUID" -> \
"fd5191b3-69ee-4d78-9e5c-dcb885943877"],
Cell[12887, 382, 270, 7, 46, "Input", "ExpressionUUID" -> \
"0749cae5-1c81-4e3f-8d65-3a26893ff34c"],
Cell[13160, 391, 863, 26, 117, "Input", "ExpressionUUID" -> \
"a9c57822-c133-4aba-b712-ef2037bad660"],
Cell[14026, 419, 371, 11, 67, "Input", "ExpressionUUID" -> \
"1688100b-bc66-426e-8c5f-b7b0a6aa1b04"]
}
]
*)

(* End of internal cache information *)

